/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.AutoCutLinesPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.constraints.CuttedConnectionConstraint;
import DE.siemens.ad.pdraw.standard.AdvancedConnectionSplitter;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;

public class AutoCutLinesAction
extends UndoableAction {
    protected Vector fCuttedConnectionConstraints;
    protected int fCutLimit = 300;
    protected boolean fCutLongLines;
    protected boolean fCutLinesIntersectingBlocks;
    protected LogoDrawing fLogoDrawing;

    public AutoCutLinesAction() {
        this.putValue("Name", "edit.autoCutLines");
        this.putValue("textKey", "edit.autoCutLines");
        this.putValue("ShortDescription", Language.getStringNoTilde("edit.autoCutLines", "edit.autoCutLines"));
    }

    public void determinLinesAndSplit(LogoDrawing logoDrawing, DrawingView view) {
        LogoProperties logoProperties = LogoProperties.instance();
        this.fCutLinesIntersectingBlocks = logoProperties.getBooleanProperty("autoCutLines.cutLinesIntersectingBlocks", true);
        this.fCutLongLines = logoProperties.getBooleanProperty("autoCutLines.cutLongLines", true);
        this.fCutLimit = logoProperties.getIntProperty("autoCutLines.cutLimit", 300);
        this.fCuttedConnectionConstraints = new Vector();
        AdvancedConnectionSplitter splitter = new AdvancedConnectionSplitter();
        Enumeration figures = ((Vector)logoDrawing.getFigures().clone()).elements();
        Figure figure = null;
        while (figures.hasMoreElements()) {
            FixedElbowConnection fec;
            figure = (Figure)figures.nextElement();
            if (!(figure instanceof FixedElbowConnection) || this.isAlreadySplitted(fec = (FixedElbowConnection)figure) || !this.isTooLong(fec) && !this.intersectesBlockFigures(logoDrawing, fec)) continue;
            CuttedConnectionConstraint ccc = splitter.splittConnection(fec, view);
            this.fCuttedConnectionConstraints.add(ccc);
            ccc.getDirectConnection().delete();
            ccc.insert(logoDrawing);
        }
    }

    public boolean doIt() {
        LogoDrawingView drawingView = this.getDrawingView();
        drawingView.clearSelection();
        Enumeration e = this.fCuttedConnectionConstraints.elements();
        CuttedConnectionConstraint ccc = null;
        while (e.hasMoreElements()) {
            ccc = (CuttedConnectionConstraint)e.nextElement();
            ccc.getDirectConnection().delete();
            ccc.insert(drawingView.drawing());
        }
        super.doIt();
        return true;
    }

    private boolean intersectesBlockFigures(Drawing drawing, FixedElbowConnection fec) {
        if (!this.fCutLinesIntersectingBlocks) {
            return false;
        }
        FigureEnumeration figures = drawing.figures();
        Figure f = null;
        while (figures.hasMoreElements()) {
            f = figures.nextFigure();
            if (!(f instanceof BlockFigure)) continue;
            Rectangle blockFigureDisplayBox = (Rectangle)((BlockFigure)f).getImageFigure().displayBox().clone();
            blockFigureDisplayBox.grow(-3, 0);
            blockFigureDisplayBox.translate(2, 0);
            if (!fec.intersectsRectangle(blockFigureDisplayBox)) continue;
            return true;
        }
        return false;
    }

    private boolean isAlreadySplitted(FixedElbowConnection fec) {
        return fec.getConstraint().getTopLevelConstraint() instanceof CuttedConnectionConstraint;
    }

    private boolean isTooLong(FixedElbowConnection fec) {
        if (!this.fCutLongLines) {
            return false;
        }
        boolean rw = Math.sqrt(Math.pow(fec.endPoint().x - fec.startPoint().x, 2.0) + Math.pow(fec.endPoint().y - fec.startPoint().y, 2.0)) > (double)this.fCutLimit;
        return rw;
    }

    public boolean needsWaitCursor() {
        return false;
    }

    public boolean prepareAction() {
        LogoDrawingView view = this.getDrawingView();
        this.fLogoDrawing = (LogoDrawing)this.getDrawingView().drawing();
        AutoCutLinesPanel autoCutLinesPanel = new AutoCutLinesPanel();
        SplittedDlg dialog = SplittedDlg.create((JFrame)this.getOwner().getWindow(), autoCutLinesPanel, 11);
        dialog.show();
        if (dialog.getControlPanel().getResult() == 2) {
            return false;
        }
        this.determinLinesAndSplit(this.fLogoDrawing, view);
        return !this.fCuttedConnectionConstraints.isEmpty();
    }

    public String toString() {
        return super.toString() + " fCuttedConnectionConstraints: " + this.fCuttedConnectionConstraints;
    }

    public void undoIt() {
        this.getDrawingView().clearSelection();
        Enumeration e = this.fCuttedConnectionConstraints.elements();
        CuttedConnectionConstraint ccc = null;
        while (e.hasMoreElements()) {
            ccc = (CuttedConnectionConstraint)e.nextElement();
            ccc.delete();
            ccc.getDirectConnection().undoDelete();
        }
        super.undoIt();
    }
}

